﻿using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System.Runtime.InteropServices;
using System.Threading;
using System.Windows.Forms;
using AForge.Imaging;
using AForge.Imaging.Filters;
namespace Aim_Labs_Testing
{
    class Program
    {

        static void Main(string[] args)
        {
            /// Program automatically aims and clicks at target on screen through a screen shot.
            Program program = new Program();
            while (true)
            {
                // Finds screen size.
                Rectangle bounds = Screen.GetBounds(Point.Empty);
                using (Bitmap screenBitmap = new Bitmap(bounds.Width, bounds.Height))
                {
                    // Gets what is on the screen currently.
                    using (Graphics g = Graphics.FromImage(screenBitmap))
                    {
                        g.CopyFromScreen(Point.Empty, Point.Empty, bounds.Size);
                    }
                    // Puts the screenshot on a bitmap.
                    Bitmap scrBM = new Bitmap(screenBitmap.Width, screenBitmap.Height, PixelFormat.Format24bppRgb);
                    using (Graphics gr = Graphics.FromImage(scrBM))
                    {
                        gr.DrawImage(screenBitmap, new Rectangle(0, 0, scrBM.Width, scrBM.Height));
                    }
                    // Pulls the image(color) to search for from a file called 'Ball.jpg'.
                    Bitmap template = (Bitmap)Bitmap.FromFile(Directory.GetCurrentDirectory() + @"\Ball.jpg");
                    scrBM = new ResizeBicubic((int)(scrBM.Width * 0.1), (int)(scrBM.Height * 0.1)).Apply(scrBM);
                    template = new ResizeBicubic((int)(template.Width * 0.1), (int)(template.Height * 0.1)).Apply(template);
                    ExhaustiveTemplateMatching tm = new ExhaustiveTemplateMatching(0.801f);
                    // Finds the position that the matching color is at on the screen shot.
                    TemplateMatch[] matchings = tm.ProcessImage(scrBM, template);
                    BitmapData data = screenBitmap.LockBits(
                           new Rectangle(0, 0, screenBitmap.Width, screenBitmap.Height),
                           ImageLockMode.ReadWrite, screenBitmap.PixelFormat);
                    // Aims and clicks at the position
                    if (matchings.Length >= 1)
                    {
                        Drawing.Rectangle(data, matchings[0].Rectangle, Color.White);
                        program.shoot_Target((int)(matchings[0].Rectangle.Location.X * 10), (int)(matchings[0].Rectangle.Location.Y * 10));
                    }
                        
                        
                }
            }
        }
        private const UInt32 MOUSEEVENTF_LEFTDOWN = 0x0002;
        private const UInt32 MOUSEEVENTF_LEFTUP = 0x0004;
        private const int MOUSEEVENTF_MOVE = 0x0001;
        [DllImport("user32.dll")]
        private static extern void mouse_event(uint dwFlags, int dx, int dy, int dwData, int dwExtraInf);
        private void shoot_Target(int x, int y)
        {
            // Used to aim and click at a given position on the screen.
            x = (int)(-(Cursor.Position.X - x));
            y = (int)(-(Cursor.Position.Y - y));
            Move(x, y);
            mouse_event(MOUSEEVENTF_LEFTDOWN, 0, 0, 0, 0);//makes left button down
            mouse_event(MOUSEEVENTF_LEFTUP, 0, 0, 0, 0);//makes left button up
            Thread.Sleep(10);
        }
        public static void Move(int xDelta, int yDelta)
        {
            // Moves mouse pointer
            mouse_event(MOUSEEVENTF_MOVE, xDelta, yDelta, 0, 0);
        }
    }
}
